/*
 * Decompiled with CFR 0.152.
 */
package threads;

import java.io.IOException;
import java.io.OutputStream;
import threads.IWriterThread;
import util.ExceptionListener;

public final class WriterThread
extends Thread
implements IWriterThread {
    private OutputStream writer;
    private ExceptionListener exListener;
    private StringBuffer buffer;
    private boolean exit;

    public WriterThread(OutputStream _writer, ExceptionListener _exListener) {
        this.writer = _writer;
        this.exListener = _exListener;
        this.buffer = new StringBuffer();
    }

    public synchronized void write(String _s) {
        this.buffer.append(_s);
        this.notify();
    }

    public synchronized void terminate() {
        this.exit = true;
        this.notify();
    }

    private synchronized void execute() throws IOException {
        this.exit = false;
        int alive = 0;
        while (!this.exit) {
            if (this.buffer.length() == 0) {
                try {
                    if (alive > 180) {
                        this.writer.write(this.unicodeToServer(" "));
                        this.writer.flush();
                        alive = 0;
                        continue;
                    }
                    this.wait(1000L);
                    ++alive;
                }
                catch (InterruptedException e) {
                    System.out.println("[INTERRUPTED EXCEPTION]");
                }
                continue;
            }
            String s = this.buffer.toString();
            this.writer.write(this.unicodeToServer(s));
            this.writer.flush();
            alive = 0;
            this.buffer = new StringBuffer(1);
        }
    }

    public void run() {
        try {
            this.execute();
        }
        catch (IOException e) {
            this.exListener.reportException(this, e);
        }
    }

    public byte[] unicodeToServer(String s) {
        byte[] b = new byte[WriterThread.strlen(s)];
        char[] a = s.toCharArray();
        int j = 0;
        for (int i = 0; i < a.length; ++i) {
            if (a[i] < '\u0080') {
                b[j] = (byte)a[i];
                ++j;
                continue;
            }
            if (a[i] < '\u0800') {
                b[j] = (byte)(0xC0 | a[i] >> 6);
                b[j + 1] = (byte)(0x80 | a[i] & 0x3F);
                j += 2;
                continue;
            }
            b[j] = (byte)(0xE0 | a[i] >> 12);
            b[j + 1] = (byte)(0x80 | a[i] >> 6 & 0x3F);
            b[j + 2] = (byte)(0x80 | a[i] & 0x3F);
            j += 3;
        }
        return b;
    }

    public static int strlen(String s) {
        int n = 0;
        char[] a = s.toCharArray();
        for (int i = 0; i < a.length; ++i) {
            if (a[i] < '\u0080') {
                ++n;
                continue;
            }
            if (a[i] < '\u0800') {
                n += 2;
                continue;
            }
            n += 3;
        }
        return n;
    }
}

